# -*- coding: utf-8 -*-
from flask import Flask, request, jsonify, render_template
from datetime import datetime
import os, json

CFG_FILE = "config.json"

def load_cfg():
    if os.path.exists(CFG_FILE):
        return json.load(open(CFG_FILE,"r",encoding="utf-8"))
    return {}

def save_cfg(cfg):
    json.dump(cfg, open(CFG_FILE,"w",encoding="utf-8"), ensure_ascii=False, indent=2)

app = Flask(__name__, template_folder="templates", static_folder="static")
app_cfg = load_cfg()

from executor import Executor
exe = Executor(app_cfg)

@app.get("/")
def home():
    return render_template("index.html", pin=app_cfg.get("WEB_PIN","1234"))

@app.get("/status")
def status():
    pin=request.args.get("pin","")
    if pin!=app_cfg.get("WEB_PIN","1234"):
        return jsonify({"ok":False}),401
    bal = exe.get_balance()
    return jsonify({"ok":True,"balance":bal,"time":datetime.now().strftime("%Y-%m-%d %H:%M:%S")})

@app.post("/connect")
def connect():
    data=request.get_json(force=True)
    pin=data.get("pin","")
    if pin!=app_cfg.get("WEB_PIN","1234"):
        return jsonify({"ok":False}),401
    app_cfg["EMAIL"]=data.get("email","").strip()
    app_cfg["SENHA"]=data.get("senha","").strip()
    app_cfg["CONTA"]=data.get("conta","PRATICA").strip().upper()
    save_cfg(app_cfg)
    ok,reason = exe.connect(app_cfg)
    return jsonify({"ok":bool(ok),"reason":reason})

@app.post("/test")
def test():
    data=request.get_json(force=True)
    pin=data.get("pin","")
    if pin!=app_cfg.get("WEB_PIN","1234"):
        return jsonify({"ok":False}),401
    par=data.get("par","EURUSD-OTC")
    side=data.get("side","call")
    ok,res,profit = exe.test_order(par, side)
    return jsonify({"ok":ok,"res":res,"profit":profit})

if __name__=="__main__":
    print("Abra: http://127.0.0.1:8099/?pin="+app_cfg.get("WEB_PIN","1234"))
    app.run(host="0.0.0.0", port=8099, debug=False)
