# -*- coding: utf-8 -*-
import os, time
try:
    from iqoptionapi.stable_api import IQ_Option
except Exception:
    IQ_Option = None

class Executor:
    def __init__(self, cfg):
        self.cfg = cfg or {}
        self.api = None

    def connect(self, cfg=None):
        cfg = cfg or self.cfg
        if IQ_Option is None:
            return False, "iqoptionapi não instalado"
        email = cfg.get("EMAIL",""); senha = cfg.get("SENHA","")
        if not email or not senha:
            return False, "E-mail/Senha vazios"
        try:
            self.api = IQ_Option(email, senha)
            ok, reason = self.api.connect()
            if ok:
                self.api.change_balance("REAL" if cfg.get("CONTA","PRATICA").upper()=="REAL" else "PRACTICE")
            return ok, str(reason)
        except Exception as e:
            return False, str(e)

    def get_balance(self):
        try:
            if self.api and self.api.check_connect():
                return f"{self.api.get_balance():,.2f} {self.api.get_currency()}"
        except Exception:
            pass
        return "—"

    def test_order(self, par, side):
        stake = float(self.cfg.get("stake",1.0))
        exp   = int(self.cfg.get("exp",1))
        if self.api is None or (not self.api.check_connect()):
            return False, "no-conn", 0.0
        try:
            prefer = self.cfg.get("preferencia","BINARIA").upper()
            minp   = float(self.cfg.get("payout_min",0.65))
            dig,binp = None,None
            try:
                allp=self.api.get_all_profit()
                if "binary" in allp and par in allp["binary"]:
                    binp=float(allp["binary"][par])
            except Exception:
                pass
            canal=None
            if prefer=="DIGITAL" and dig and dig>=minp: canal="DIGITAL"
            elif binp and binp>=minp: canal="BINARIA"
            else:
                canal="BINARIA"
            if canal=="DIGITAL":
                st,ticket=self.api.buy_digital_spot(par, stake, side, exp)
                if not st: return False, "reject-digital", 0.0
                time.sleep(exp*60+5); res, lucro=self.api.check_win_v3(ticket)
            else:
                ok, oid=self.api.buy(stake, par, side, exp)
                if not ok: return False, "reject-binary", 0.0
                time.sleep(exp*60+5); res, lucro=self.api.check_win_v3(oid)
            return True, res, float(lucro or 0.0)
        except Exception as e:
            return False, str(e), 0.0
